///////////////////////////////////////////////////////////////////////////////
//
//   CONEXANT SYSTEMS INC - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1392.C - Message 1392 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1392 messages.
//
//   Originator : Hao Q. Phung
//   REVISION HISTORY
//
//
//   $Log:   V:\Projects\Labmon\Source\Archives\msg1392.c_v  $ 
//   
//      Rev 1.0   08 Dec 1999 14:42:46   dangmk
//    
//
//
//
////////////////////////////////////////////////////////////////////////////////

#include <string.h>
#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"

void wait(float);  
void clear_message_line(void);   

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1392 message from the ZMsgBuf.
//
void Bld1392(tMSGBUF *ZMsgBuf, tMSG1392 *Msg)
{
   // copy message into buffer
   memcpy(((tSHORT *) ZMsgBuf)+5, Msg, sizeof(*Msg));          

   // build the header in the buffer
   PutShort  (0x81FF                        , ZMsgBuf, 1);     // message preamble
   PutShort  (1392                          , ZMsgBuf, 2);     // message number
   PutShort  (21                            , ZMsgBuf, 3);     // message length 
   PutShort  (ANREQ                         , ZMsgBuf, 4);     // message ack/nack request

}                                      
                                     
   
//   Display a Zodiac 1392 message from the ZMsgBuf.
//
//void Show1392(tMSG1392 *Msg)
//{
//}                                                 
                                      
                                           
